﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using PI.FM.N000.Base.WinForms.Controls;

namespace PI.ZB.N1200.ELearning.WinForms.Config
{
    public partial class UCTabAdditionalConfig : PI.FM.N000.Base.WinForms.Controls.TabPageContainerControl
    {
        public UCTabAdditionalConfig()
        {
            InitializeComponent();
            Dock = DockStyle.Fill;
        }

        protected UCOptionsDetails UCDetails
        {
            get { return (UCOptionsDetails)base.UCBODetails; }
        }

        protected override void OnInitialize()
        {
            base.OnInitialize();

            _gPictureBox.LoadCompleted += new AsyncCompletedEventHandler(ImageLoadCompleted);
        }

        void ImageLoadCompleted(object sender, AsyncCompletedEventArgs e)
        {
            Gemini.Core.WinForms.Controls.GPictureBox _gPictureBox = sender as Gemini.Core.WinForms.Controls.GPictureBox;

            if (_gPictureBox != null)
            {
                _gPictureBox.Visible = true;
            }

        }


        public override bool DoSave()
        {
            bool _return = true;

            _return &= UCDetails.BLVariableRepository.Set(BL.Dictionary.Config.AdditionalConfig.MainPortalAddress, BL.Dictionary.Clients.PlugIn, _gTextBoxAddress.Text);
            return _return;
        }

        public override void DoRestore()
        {
            _gTextBoxAddress.Text = UCDetails.BLVariableRepository.GetString(BL.Dictionary.Config.AdditionalConfig.MainPortalAddress, BL.Dictionary.Clients.PlugIn, String.Empty);
        }
    }
}
